# 機能設計書 33-Device Taint Evictionコントローラー

## 概要

本ドキュメントは、Kubernetes kube-controller-managerに含まれるDevice Taint Evictionコントローラーの機能設計を記述する。DRA（Dynamic Resource Allocation）デバイスに対するNoExecute Taintによるpod退避を管理する。

### 本機能の処理概要

**業務上の目的・背景**：DRA（Dynamic Resource Allocation）を使用する環境では、デバイス（GPU、FPGAなど）に対してTaintを付与できる。Device Taint Evictionコントローラーは、NoExecute効果のデバイスTaintに対応し、そのTaintをTolerationで許容していないPodを退避する。

**機能の利用シーン**：デバイスの障害検出時、デバイスのメンテナンス時、DeviceTaintRuleリソースによる自動Taint付与時に動作する。

**主要な処理内容**：
1. ResourceSlice内のデバイスTaint（NoExecute）の変更を監視する
2. PodのResourceClaim（割り当て済みデバイス）のTolerationを評価する
3. 許容されていないTaintが存在するPodを退避対象とする
4. TolerationSecondsが設定されている場合、指定時間後に退避をスケジュールする
5. Pod削除前にDisruptionTarget条件を設定する

**関連システム・外部連携**：DRA（Dynamic Resource Allocation）、ResourceSlice、ResourceClaim、DeviceTaintRule

**権限による制御**：Pod、ResourceSlice、ResourceClaim、DeviceTaintRuleに対するGet、List、Watch権限が必要。

## 関連画面

本機能はバックエンドコントローラーであり、直接的な画面関連はない。

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | - |

## 機能種別

イベント駆動処理 / Pod退避（削除）操作

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| ResourceSlice.Spec.Devices[].Taints | []Taint | No | デバイスのTaintリスト | Effect=NoExecuteが対象 |
| ResourceClaim.Status.Allocation | AllocationResult | Yes | 割り当て済みデバイス情報 | - |
| Pod.Spec.ResourceClaims | []PodResourceClaim | No | Podのリソースクレーム参照 | - |

### 入力データソース

- ResourceSlice Informer: デバイスTaint変更イベント
- Pod Informer: Pod作成・更新・削除イベント
- ResourceClaim Informer: クレーム割り当て変更イベント

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| Pod削除 | - | デバイスTaintを許容しないPodの削除 |
| Pod.Status.Conditions | []v1.PodCondition | DisruptionTarget条件の追加 |

### 出力先

- Kubernetes API Server（Pod削除、ステータスパッチ）

## 処理フロー

### 処理シーケンス

```
1. デバイスTaint変更（ResourceSlice更新）を検出
   └─ processResourceSlice()でデバイスTaintを抽出
   └─ 影響を受けるPodをenqueue
2. Pod変更を検出
   └─ processPod()でPodのResourceClaimを解析
3. syncPod()で退避判定
   └─ getDeviceTaintsForPod()でPodが使用するデバイスのTaintを収集
   └─ getTolerations()でPodのTolerationを取得
   └─ checkTolerations()で許容判定
4. 退避スケジュール
   └─ TolerationSecondsが設定されている場合は遅延退避
   └─ 設定されていない場合は即座に退避
5. Pod削除実行
   └─ DisruptionTarget条件をパッチ
   └─ Pod削除API呼び出し
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-33-01 | デバイスTaint退避 | NoExecuteデバイスTaintを許容しないPodを退避する | ResourceSliceにNoExecute Taintが存在する場合 |
| BR-33-02 | TolerationSeconds | デバイスTolerationSecondsが設定されている場合、その秒数後に退避 | Tolerationが存在し秒数指定がある場合 |
| BR-33-03 | DRA連携 | ResourceClaimの割り当て情報からデバイスとPodの対応を解決する | Pod退避判定時 |
| BR-33-04 | Feature Gate依存 | DRADeviceTaintEviction Feature Gateが有効な場合のみ動作する | コントローラー起動時 |

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| Pod退避 | Pod | DELETE | 退避対象Podの削除 |
| 条件追加 | Pod | PATCH (Status) | DisruptionTarget条件の追加 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NotFound | リソース不在 | Pod/ResourceSliceが既に削除されている | 正常終了扱い |
| - | 削除失敗 | API Server通信エラー | リトライ |

## トランザクション仕様

Node Taint Evictionコントローラーと同様、DisruptionTarget条件追加とPod削除は別API呼び出し。

## パフォーマンス要件

- ワーカー数: 設定可能（デフォルトはKubeControllerManagerのオプションに依存）
- ResourceSlice Informerのキャッシュを活用してAPI呼び出しを最小化

## セキュリティ考慮事項

- DRADeviceTaintEviction Feature Gateによる機能制御
- Pod削除前にDisruptionTarget条件で監査証跡を残す

## 備考

- 本コントローラーはDRADeviceTaintEvictionフィーチャーゲート有効時のみ動作する
- Taint Evictionコントローラーと類似設計だが、Node TaintではなくDevice Taintを対象とする

---

## コードリーディングガイド

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | device_taint_eviction.go | `pkg/controller/devicetainteviction/device_taint_eviction.go` | Controller構造体のフィールド定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | device_taint_eviction.go | `pkg/controller/devicetainteviction/device_taint_eviction.go` | New関数でInformer登録、Run関数でワーカー起動 |

#### Step 3: sync処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | device_taint_eviction.go | `pkg/controller/devicetainteviction/device_taint_eviction.go` | syncPod関数でデバイスTaint評価とPod退避判定 |

### プログラム呼び出し階層図

```
New
    ├─ addPod/updatePod/deletePod → podQueue.Add
    ├─ addResourceSlice/updateResourceSlice → enqueueAffectedPods
    └─ addResourceClaim/updateResourceClaim → enqueueAffectedPods

Run
    └─ worker
        └─ processNextWorkItem
            └─ syncPod
                ├─ getDeviceTaintsForPod
                │   ├─ getResourceClaimsForPod
                │   └─ getDeviceTaintsFromResourceSlice
                ├─ getTolerations
                ├─ checkTolerations
                └─ deletePodHandler / scheduleEviction
```

### データフロー図

```
[入力]                         [処理]                    [出力]

ResourceSlice変更  ──▶  enqueueAffectedPods ──▶         Pod削除
                              │
ResourceClaim変更  ──▶  podQueue           ──▶ syncPod  DisruptionTarget
                              │                          条件
Pod変更           ──▶  worker              ──▶
                        ├─ getDeviceTaintsForPod
                        ├─ checkTolerations
                        └─ deletePod/scheduleEviction
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| device_taint_eviction.go | `pkg/controller/devicetainteviction/device_taint_eviction.go` | ソース | コントローラー本体 |
| device_taint_eviction_test.go | `pkg/controller/devicetainteviction/device_taint_eviction_test.go` | テスト | ユニットテスト |
